using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class PeopleBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            MicroFour.StrataFrame.Business.RequiredField RequiredField1 = new MicroFour.StrataFrame.Business.RequiredField();
            MicroFour.StrataFrame.Business.RequiredField RequiredField2 = new MicroFour.StrataFrame.Business.RequiredField();
            //
            //PeopleBO
            //
            this.DeleteUsingStoredProcedure = true;
            this.InsertUsingStoredProcedure = true;
            RequiredField1.FieldName = "pl_Code";
            RequiredField1.FieldType = System.Data.SqlDbType.Text;
            RequiredField2.FieldName = "pl_FirstName";
            RequiredField2.FieldType = System.Data.SqlDbType.Text;
            this.RequiredFields.AddRange(new MicroFour.StrataFrame.Business.RequiredField[] { RequiredField1, RequiredField2 });
            this.RowVersionOrTimestampColumn = "pl_Version";
            this.UpdateConcurrencyType = MicroFour.StrataFrame.Data.ConcurrencyTypeOptions.OptimisticRowVersion;
            this.UpdateUsingStoredProcedure = true;

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[pl_pk],[pl_Code],[pl_FirstName],[pl_MiddleName],[pl_LastName],[pl_CreatedAt],[pl_CreatedBy],[pl_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "pl_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "People";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("pl_pk", typeof(System.Int32)),
new DataColumn("pl_Code", typeof(System.String)),
new DataColumn("pl_FirstName", typeof(System.String)),
new DataColumn("pl_MiddleName", typeof(System.String)),
new DataColumn("pl_LastName", typeof(System.String)),
new DataColumn("pl_CreatedAt", typeof(System.DateTime)),
new DataColumn("pl_CreatedBy", typeof(System.Int32)),
new DataColumn("pl_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(PeopleBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(PeopleBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pl_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["pl_pk"];
            }
            set
            {
                this.CurrentRow["pl_pk"] = value;
            }
        }

        /// <summary>
        /// Identification Code
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Identification Code"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String pl_Code
        {
            get
            {
                return (System.String)this.CurrentRow["pl_Code"];
            }
            set
            {
                this.CurrentRow["pl_Code"] = value;
            }
        }

        /// <summary>
        /// First Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("First Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String pl_FirstName
        {
            get
            {
                return (System.String)this.CurrentRow["pl_FirstName"];
            }
            set
            {
                this.CurrentRow["pl_FirstName"] = value;
            }
        }

        /// <summary>
        /// Middle Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Middle Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String pl_MiddleName
        {
            get
            {
                return (System.String)this.CurrentRow["pl_MiddleName"];
            }
            set
            {
                this.CurrentRow["pl_MiddleName"] = value;
            }
        }

        /// <summary>
        /// Last Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Last Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String pl_LastName
        {
            get
            {
                return (System.String)this.CurrentRow["pl_LastName"];
            }
            set
            {
                this.CurrentRow["pl_LastName"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime pl_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["pl_CreatedAt"];
            }
            set
            {
                this.CurrentRow["pl_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// User Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("User Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pl_CreatedBy
        {
            get
            {
                return (System.Int32)this.CurrentRow["pl_CreatedBy"];
            }
            set
            {
                this.CurrentRow["pl_CreatedBy"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pl_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["pl_Version"];
            }
            set
            {
                this.CurrentRow["pl_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum PeopleBOFieldNames
        {
            pl_pk,
            pl_Code,
            pl_FirstName,
            pl_MiddleName,
            pl_LastName,
            pl_CreatedAt,
            pl_CreatedBy,
            pl_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(PeopleBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<PeopleBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<PeopleBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<PeopleBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the PeopleBO class.
        /// </summary>
        static PeopleBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(13);
            _PropertyDescriptors.Add("pl_pk", new FieldDescriptor(PeopleBOFieldNames.pl_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("pl_Code", new FieldDescriptor(PeopleBOFieldNames.pl_Code, typeof(System.String)));
            _PropertyDescriptors.Add("pl_FirstName", new FieldDescriptor(PeopleBOFieldNames.pl_FirstName, typeof(System.String)));
            _PropertyDescriptors.Add("pl_MiddleName", new FieldDescriptor(PeopleBOFieldNames.pl_MiddleName, typeof(System.String)));
            _PropertyDescriptors.Add("pl_LastName", new FieldDescriptor(PeopleBOFieldNames.pl_LastName, typeof(System.String)));
            _PropertyDescriptors.Add("pl_CreatedAt", new FieldDescriptor(PeopleBOFieldNames.pl_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("pl_CreatedBy", new FieldDescriptor(PeopleBOFieldNames.pl_CreatedBy, typeof(System.Int32)));
            _PropertyDescriptors.Add("pl_Version", new FieldDescriptor(PeopleBOFieldNames.pl_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(8);
            _AllFieldsList.Add("pl_pk");
            _AllFieldsList.Add("pl_Code");
            _AllFieldsList.Add("pl_FirstName");
            _AllFieldsList.Add("pl_MiddleName");
            _AllFieldsList.Add("pl_LastName");
            _AllFieldsList.Add("pl_CreatedAt");
            _AllFieldsList.Add("pl_CreatedBy");
            _AllFieldsList.Add("pl_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(8);
            _FieldDbTypes.Add("pl_pk", DbType.Int32);
            _FieldDbTypes.Add("pl_Code", DbType.AnsiString);
            _FieldDbTypes.Add("pl_FirstName", DbType.String);
            _FieldDbTypes.Add("pl_MiddleName", DbType.String);
            _FieldDbTypes.Add("pl_LastName", DbType.String);
            _FieldDbTypes.Add("pl_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("pl_CreatedBy", DbType.Int32);
            _FieldDbTypes.Add("pl_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(9);
            _FieldEnums.Add("pl_pk", PeopleBOFieldNames.pl_pk);
            _FieldEnums.Add("pl_Code", PeopleBOFieldNames.pl_Code);
            _FieldEnums.Add("pl_FirstName", PeopleBOFieldNames.pl_FirstName);
            _FieldEnums.Add("pl_MiddleName", PeopleBOFieldNames.pl_MiddleName);
            _FieldEnums.Add("pl_LastName", PeopleBOFieldNames.pl_LastName);
            _FieldEnums.Add("pl_CreatedAt", PeopleBOFieldNames.pl_CreatedAt);
            _FieldEnums.Add("pl_CreatedBy", PeopleBOFieldNames.pl_CreatedBy);
            _FieldEnums.Add("pl_Version", PeopleBOFieldNames.pl_Version);
            _FieldEnums.Add("CUSTOM_FIELD", PeopleBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(8);
            _FieldLengths.Add("pl_pk", 4);
            _FieldLengths.Add("pl_Code", 10);
            _FieldLengths.Add("pl_FirstName", 50);
            _FieldLengths.Add("pl_MiddleName", 50);
            _FieldLengths.Add("pl_LastName", 50);
            _FieldLengths.Add("pl_CreatedAt", 8);
            _FieldLengths.Add("pl_CreatedBy", 4);
            _FieldLengths.Add("pl_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(8);
            _FieldNativeDbTypes.Add("pl_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("pl_Code", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("pl_FirstName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("pl_MiddleName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("pl_LastName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("pl_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("pl_CreatedBy", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("pl_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(8);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the PeopleBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<PeopleBOFieldNames>
        {
            public FieldDescriptor(PeopleBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(PeopleBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case PeopleBOFieldNames.pl_pk:
                        return ((PeopleBO)component).pl_pk;
                    case PeopleBOFieldNames.pl_Code:
                        return ((PeopleBO)component).pl_Code;
                    case PeopleBOFieldNames.pl_FirstName:
                        return ((PeopleBO)component).pl_FirstName;
                    case PeopleBOFieldNames.pl_MiddleName:
                        return ((PeopleBO)component).pl_MiddleName;
                    case PeopleBOFieldNames.pl_LastName:
                        return ((PeopleBO)component).pl_LastName;
                    case PeopleBOFieldNames.pl_CreatedAt:
                        return ((PeopleBO)component).pl_CreatedAt;
                    case PeopleBOFieldNames.pl_CreatedBy:
                        return ((PeopleBO)component).pl_CreatedBy;
                    case PeopleBOFieldNames.pl_Version:
                        return ((PeopleBO)component).pl_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case PeopleBOFieldNames.pl_pk:
                        ((PeopleBO)component).pl_pk = (System.Int32)value;
                        break;
                    case PeopleBOFieldNames.pl_Code:
                        ((PeopleBO)component).pl_Code = (System.String)value;
                        break;
                    case PeopleBOFieldNames.pl_FirstName:
                        ((PeopleBO)component).pl_FirstName = (System.String)value;
                        break;
                    case PeopleBOFieldNames.pl_MiddleName:
                        ((PeopleBO)component).pl_MiddleName = (System.String)value;
                        break;
                    case PeopleBOFieldNames.pl_LastName:
                        ((PeopleBO)component).pl_LastName = (System.String)value;
                        break;
                    case PeopleBOFieldNames.pl_CreatedAt:
                        ((PeopleBO)component).pl_CreatedAt = (System.DateTime)value;
                        break;
                    case PeopleBOFieldNames.pl_CreatedBy:
                        ((PeopleBO)component).pl_CreatedBy = (System.Int32)value;
                        break;
                    case PeopleBOFieldNames.pl_Version:
                        ((PeopleBO)component).pl_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
